module RPG
  class State
    def initialize
      @id = 0
      @name = ""
      @animation_id = 0
      @restriction = 0
      @nonresistance = false
      @zero_hp = false
      @cant_get_exp = false
      @cant_evade = false
      @slip_damage = false
      @rating = 5
      @hit_rate = 100
      @maxhp_rate = 100
      @maxsp_rate = 100
      @str_rate = 100
      @dex_rate = 100
      @agi_rate = 100
      @int_rate = 100
      @atk_rate = 100
      @pdef_rate = 100
      @mdef_rate = 100
      @eva = 0
      @battle_only = true
      @hold_turn = 0
      @auto_release_prob = 0
      @shock_release_prob = 0
      @guard_element_set = []
      @plus_state_set = []
      @minus_state_set = []
    end
    attr_accessor :id
    attr_accessor :name
    attr_accessor :animation_id
    attr_accessor :restriction
    attr_accessor :nonresistance
    attr_accessor :zero_hp
    attr_accessor :cant_get_exp
    attr_accessor :cant_evade
    attr_accessor :slip_damage
    attr_accessor :rating
    attr_accessor :hit_rate
    attr_accessor :maxhp_rate
    attr_accessor :maxsp_rate
    attr_accessor :str_rate
    attr_accessor :dex_rate
    attr_accessor :agi_rate
    attr_accessor :int_rate
    attr_accessor :atk_rate
    attr_accessor :pdef_rate
    attr_accessor :mdef_rate
    attr_accessor :eva
    attr_accessor :battle_only
    attr_accessor :hold_turn
    attr_accessor :auto_release_prob
    attr_accessor :shock_release_prob
    attr_accessor :guard_element_set
    attr_accessor :plus_state_set
    attr_accessor :minus_state_set


    ###########################################
    # Ajouts aux classes
    ###########################################

    def to_dmk
      my = self.cast(My_RPG::My_State)
      return my
    end


    def comparer(other)
      
      list_self = [
        @id,
        @name,
        @animation_id,
        @restriction,
        @nonresistance,
        @zero_hp,
        @cant_get_exp,
        @cant_evade,
        @slip_damage,
        @rating,
        @hit_rate,
        @maxhp_rate,
        @maxsp_rate,
        @str_rate,
        @dex_rate,
        @agi_rate,
        @int_rate,
        @atk_rate,
        @pdef_rate,
        @mdef_rate,
        @eva,
        @battle_only,
        @hold_turn,
        @auto_release_prob,
        @shock_release_prob,
        @guard_element_set,
        @plus_state_set,
        @minus_state_set
      ]

      list_other = [
        other.id,
        other.name,
        other.animation_id,
        other.restriction,
        other.nonresistance,
        other.zero_hp,
        other.cant_get_exp,
        other.cant_evade,
        other.slip_damage,
        other.rating,
        other.hit_rate,
        other.maxhp_rate,
        other.maxsp_rate,
        other.str_rate,
        other.dex_rate,
        other.agi_rate,
        other.int_rate,
        other.atk_rate,
        other.pdef_rate,
        other.mdef_rate,
        other.eva,
        other.battle_only,
        other.hold_turn,
        other.auto_release_prob,
        other.shock_release_prob,
        other.guard_element_set,
        other.plus_state_set,
        other.minus_state_set
      ]

      if list_self != list_other
        raise(DMKW_DMK_Diff.new("state.parameters"))
      end

      return true
    end


  end
end
